Rem
Rem $Header: rdbms/demo/syncref_run.sql /main/4 2012/05/13 18:59:51 sramakri Exp $
Rem
Rem syncref_run.sql
Rem
Rem Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      syncref_run.sql - Sync Refresh demo driver 
Rem
Rem    DESCRIPTION
Rem      Driver for the Sync Refresh demo
Rem
Rem    DESCRIPTION
Rem      This script demonstrates the Sync Refresh operations using staging logs 
Rem      and registered-partition-operations for loading change data. It also 
Rem      demonstrates the use of the wrapper procedures DO_CST and DO_CST_ARR
Rem      for can_syncref_table.
Rem
Rem    NOTES
Rem      This script includes the following scripts:
Rem          syncref_setup.sql
Rem          utlsrt.sql
Rem          syncref_cst.sql
Rem          syncref_cleanup.sql
Rem      Please copy all these scripts into your work directory before
Rem      running this script. The expected log output from this file is stored
Rem      in syncref_run.log.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sramakri    03/11/12 - fix comments for user_sr_stlog_stats usage
Rem    sramakri    02/24/12 - change refresh_force to
Rem                           refresh_using_trusted_constraints
Rem    xiaobma     02/14/12 - Lrg 6667487:Validate partition range
Rem    sramakri    01/09/12 - Sync Refresh demo
Rem    sramakri    01/09/12 - Created
Rem

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100
SET ECHO ON
SET SQLBLANKLINES ON

---------------------------------------------------------------------------
--
-- Run syncref_setup.sql to create the user and tablespaces referenced in this script.
-- 

@syncref_setup.sql

---------------------------------------------------------------------------
---
--- The following session shows how to set up the base-tables and mv
--- for sync-refresh, create and populate staging logs and use sync-refresh
--- operations to refresh the group. The sync-refresh catalog views present 
--- useful status information after each step in this process and their
--- usage is also illustrated here.
---  


connect syncref_user/syncref_user

CREATE TABLE time(
	time_key		date primary key,
	month			integer,
	year			integer,
	quarter			integer);


CREATE TABLE store(
	store_key		integer primary key,
	store_number		integer,
	store_name		varchar2(20),
	zipcode                 varchar2(20));


CREATE TABLE fact(
	time_key		date not null references time(time_key),
	store_key		integer not null references store(store_key),
	dollar_sales		number (6,2),
	unit_sales		integer)
  PARTITION by RANGE (time_key) 
      (partition fp1  
	  values less than (TO_DATE('31-12-1997', 'DD-MM-YYYY'))
  	  tablespace syncref_fp1_tbs,
       partition fp2  
	  values less than (TO_DATE('31-01-1998', 'DD-MM-YYYY'))
  	  tablespace syncref_fp2_tbs,
      partition fp3 
	  values less than (TO_DATE('28-02-1998', 'DD-MM-YYYY'))
  	  tablespace syncref_fp3_tbs);

INSERT INTO time VALUES('10-DEC-1997', 199712, 1997, 19974);
INSERT INTO time VALUES('10-JAN-1998', 199801, 1998, 19981);
INSERT INTO time VALUES('11-JAN-1998', 199801, 1998, 19981);
INSERT INTO time VALUES('10-FEB-1998', 199802, 1998, 19982);

INSERT INTO store VALUES(1, 1, 'Store 1', '03060');
INSERT INTO store VALUES(2, 2, 'Store 2', '03062');
INSERT INTO store VALUES(3, 3, 'Store 3', '03060');
INSERT INTO store VALUES(4, 4, 'Store 4', '03062');

INSERT INTO fact VALUES('10-DEC-1997', 1, 100, 100);
INSERT INTO fact VALUES('10-DEC-1997', 2, 200, 200);
INSERT INTO fact VALUES('10-DEC-1997', 4, 400, 400);

INSERT INTO fact VALUES('10-JAN-1998', 1, 100, 100);
INSERT INTO fact VALUES('10-JAN-1998', 2, 200, 200);
INSERT INTO fact VALUES('11-JAN-1998', 1, 100, 100);
INSERT INTO fact VALUES('11-JAN-1998', 2, 200, 200);

INSERT INTO fact VALUES('10-FEB-1998', 1, 100, 100);
INSERT INTO fact VALUES('10-FEB-1998', 2, 200, 200);
INSERT INTO fact VALUES('10-FEB-1998', 3, 300, 300);
INSERT INTO fact VALUES('10-FEB-1998', 4, 400, 400);

-- Create the staging logs - this will register the three tables for sync-refresh
CREATE MATERIALIZED VIEW LOG on FACT FOR SYNCHRONOUS REFRESH USING ST_FACT;
CREATE MATERIALIZED VIEW LOG on STORE FOR SYNCHRONOUS REFRESH USING ST_STORE;
CREATE MATERIALIZED VIEW LOG on TIME FOR SYNCHRONOUS REFRESH USING ST_TIME;

-- Create mv and register it for sync-refresh

CREATE MATERIALIZED VIEW mv1
  PARTITION BY RANGE (time_key)
  (
    partition mvp1
      values less than (TO_DATE('31-12-1997', 'DD-MM-YYYY'))
      tablespace syncref_mvp1_tbs,

    partition mvp2
      values less than (TO_DATE('31-01-1998', 'DD-MM-YYYY'))
      tablespace syncref_mvp2_tbs,

    partition mvp3
      values less than (TO_DATE('28-02-1999', 'DD-MM-YYYY'))
      tablespace syncref_mvp3_tbs
 )
REFRESH USING TRUSTED CONSTRAINTS
 AS
 SELECT f.store_key, s.store_name, t.year, f.time_key,
        SUM(f.dollar_sales) as dollar_sales, 
        COUNT(f.dollar_sales) as cnt_dsales,
        COUNT(*) as cnt
 FROM fact f, store s, time t
 WHERE s.store_key = f.store_key  AND
       f.time_key = t.time_key
 GROUP BY t.year, f.store_key, s.store_name, f.time_key;


execute dbms_sync_refresh.register_mviews('MV1');

col name format a10
col type format a10
col staging_log_name format a16

-- Display registered objects in the group
select name, type, staging_log_name from user_sr_obj 
where group_id = dbms_sync_refresh.get_group_id('MV1') 
order by type, name;


-- Populate staging-logs with change-data

insert into  st_time (dmltype$$, time_key, month, year, quarter)
values ('I', '11-FEB-1998', 199802, 1998, 19982);

insert into st_store (dmltype$$, store_key, store_number, store_name, zipcode)
values ('I',   5, 5, 'Store 5', '03060');

insert into st_store (dmltype$$, store_key, store_number, store_name, zipcode)
values ('I',   6,	6, 'Store 6', '03062');

insert into st_store (dmltype$$, store_key, store_number, store_name, zipcode)
values ('UO',  4,	4, 'Store 4', '03062');

insert into st_store (dmltype$$, store_key, store_number, store_name, zipcode)
values ('UN',  4, 4, 'Stor4NewNam', '03062');

insert into st_store (dmltype$$, store_key, store_number, store_name, zipcode)
values ('D',   3, 3, 'Store 3', '03060');


insert into st_fact (dmltype$$, time_key, store_key, dollar_sales, unit_sales)
values('I', '11-FEB-1998', 1, 100, 100);

insert into st_fact (dmltype$$, time_key, store_key, dollar_sales, unit_sales)
values('I', '11-FEB-1998', 2, 200, 200);

insert into st_fact (dmltype$$, time_key, store_key, dollar_sales, unit_sales)
values('D', '10-FEB-1998', 3, 300, 300);

insert into st_fact (dmltype$$, time_key, store_key, dollar_sales, unit_sales)
values('I', '11-FEB-1998', 5, 500, 500);

insert into st_fact (dmltype$$, time_key, store_key, dollar_sales, unit_sales)
values('I', '10-FEB-1998', 6, 600, 600);

insert into st_fact (dmltype$$, time_key, store_key, dollar_sales, unit_sales)
values('UO', '10-FEB-1998', 4, 400, 400);

insert into st_fact (dmltype$$, time_key, store_key, dollar_sales, unit_sales)
values('UN', '10-FEB-1998', 4, 401, 401);


-- Prepare the staging logs 

execute dbms_sync_refresh.prepare_staging_log('syncref_user', 'fact');
execute dbms_sync_refresh.prepare_staging_log('syncref_user', 'time');
execute dbms_sync_refresh.prepare_staging_log('syncref_user', 'store');


col table_name format a10
col staging_log_name format a16
col num_inserts format 999
col num_deletes format 999
col num_updates format 999

col operation format a10
col name format a16
col status  format a16

col store_key format 9999
col dollar_sales format 99999
col cnt_sales format 99999
col cnt format 999
col time_key format a10
col store_name format a11

-- Check status of staging logs after preparation;
-- the number of inserts, deletes and updates are non-null values
select table_name, staging_log_name, num_inserts, num_deletes, num_updates 
from user_sr_stlog_stats
order by table_name;


-- Display base-tables contents before refresh 

select * from time order by time_key;
select * from store order by store_key;

select * from fact partition (fp1) order by time_key, store_key;

select * from fact partition (fp2) order by time_key, store_key;

select * from fact partition (fp3) order by time_key, store_key;

-- Display MV contents before refresh 

select * from mv1 partition (mvp1) order by time_key, store_key;

select * from mv1 partition (mvp2) order by time_key, store_key;

select * from mv1 partition (mvp3) order by time_key, store_key;



--
-- Do the refresh operations and display status from the catalog
-- views after each
--

-- prepare_refresh
execute dbms_sync_refresh.prepare_refresh( -
                    dbms_sync_refresh.get_group_id('MV1'));

--
-- display status of objects after prepare_refresh
-- 

-- Check status of staging logs after prepare_refresh;
-- the number of inserts, deletes and updates are non-null values
-- indicating that the logs have not been proceesed yet
select table_name, staging_log_name, num_inserts, num_deletes, num_updates 
from user_sr_stlog_stats
order by table_name;

-- Check status of objects in the group
select name, type, status from user_sr_obj_status 
where group_id = dbms_sync_refresh.get_group_id('MV1') 
order by type, name;

-- Check status of the group itself after the prepare_refresh
-- operation; note the operation field is set to PREPARE and 
-- and status is COMPLETE
select operation, status from user_sr_grp_status
where group_id = dbms_sync_refresh.get_group_id('MV1');


-- execute_refresh
execute dbms_sync_refresh.execute_refresh( -
                 dbms_sync_refresh.get_group_id('MV1'));


--
-- display status of objects after execute_refresh
-- 

-- Check status of staging logs after execute_refresh;
-- the change data have been processed by refresh and
-- so there are no rows.
select table_name, staging_log_name, num_inserts, num_deletes, num_updates 
from user_sr_stlog_stats
order by table_name;

-- Check status of objects in the group
select name, type, status from user_sr_obj_status 
where group_id = dbms_sync_refresh.get_group_id('MV1') 
order by type, name;

-- Check status of the group itself after the execute_refresh
-- operation; note the operation field is set to EXECUTE and 
-- and status is COMPLETE
select operation, status from user_sr_grp_status
where group_id = dbms_sync_refresh.get_group_id('MV1');



-- Display base-tables contents after refresh 

select * from time order by time_key;
select * from store order by store_key;

select * from fact partition (fp1) order by time_key, store_key;

select * from fact partition (fp2) order by time_key, store_key;

select * from fact partition (fp3) order by time_key, store_key;


-- Display MV contents after refresh 

select * from mv1 partition (mvp1) order by time_key, store_key;

select * from mv1 partition (mvp2) order by time_key, store_key;

select * from mv1 partition (mvp3) order by time_key, store_key;

-- The data in staging-logs has been processed during the
-- execute_refresh, but the rows do not get deleted from the
-- staging logs themsevles. To prepare for the next refresh operation,
-- we delete the 7 rows inserted into ST_FACT, the 1 row inserted into
-- ST_TIME and the 5 rows inserted into ST_STORE.
delete from st_fact;
delete from st_time;
delete from st_store;

---------------------------------------------------------------------------
---
--- The following session shows the use of register_mviews to register 
--- additional mvs in the same group as mv1.
---

connect syncref_user/syncref_user

-- Create additional mvs and register them

CREATE MATERIALIZED VIEW mv2
  PARTITION BY RANGE (month)
  (
    partition year1_mv
      values less than (199712)
      tablespace syncref_mvp1_tbs,

    partition year2_mv
      values less than (199812)
      tablespace syncref_mvp2_tbs
 )
REFRESH USING TRUSTED CONSTRAINTS
 AS
 SELECT  s.zipcode, t.month, 
        SUM(f.dollar_sales) as dollar_sales, 
        COUNT(f.dollar_sales) as cnt_dsales,
        COUNT(*) as cnt
 FROM fact f, store s, time t
 WHERE s.store_key = f.store_key  AND
       f.time_key = t.time_key
 GROUP BY s.zipcode, t.month;


CREATE MATERIALIZED VIEW mv2_year
  PARTITION BY RANGE (year)
  (
    partition year1_mv
      values less than (1998)
      tablespace syncref_mvp1_tbs,

    partition year2_mv
      values less than (1999)
      tablespace syncref_mvp2_tbs
 )
REFRESH USING TRUSTED CONSTRAINTS
 AS
 SELECT  s.zipcode, t.year, 
        SUM(f.dollar_sales) as dollar_sales, 
        COUNT(f.dollar_sales) as cnt_dsales,
        COUNT(*) as cnt
 FROM fact f, store s, time t
 WHERE s.store_key = f.store_key  AND
       f.time_key = t.time_key
 GROUP BY s.zipcode, t.year;

CREATE MATERIALIZED VIEW mv1_halfmonth
  PARTITION BY RANGE (time_key)
  (
    partition month1_mv_first
      values less than (TO_DATE('15-12-1997', 'DD-MM-YYYY'))
      tablespace syncref_mvp1_tbs,

    partition month1_mv_second
      values less than (TO_DATE('31-12-1997', 'DD-MM-YYYY'))
      tablespace syncref_mvp2_tbs,

    partition month2_mv_first
      values less than (TO_DATE('15-01-1998', 'DD-MM-YYYY'))
      tablespace syncref_mvp3_tbs,

    partition month2_mv_second
      values less than (TO_DATE('31-01-1998', 'DD-MM-YYYY'))
      tablespace syncref_mvp1_tbs,

    partition month3_mv_first
      values less than (TO_DATE('15-02-1999', 'DD-MM-YYYY'))
      tablespace syncref_mvp2_tbs,

    partition month3_mv_second
      values less than (TO_DATE('28-02-1999', 'DD-MM-YYYY'))
      tablespace syncref_mvp3_tbs
 )
REFRESH USING TRUSTED CONSTRAINTS
 AS
 SELECT f.store_key, s.store_name, t.year, f.time_key,
        SUM(f.dollar_sales) as dollar_sales, 
        COUNT(f.dollar_sales) as cnt_dsales,
        COUNT(*) as cnt
 FROM fact f, store s, time t
 WHERE s.store_key = f.store_key  AND
       f.time_key = t.time_key
 GROUP BY t.year, f.store_key, s.store_name, f.time_key;


-- Register the new mv's - they will be in the same group as mv1
-- since they share the same tables
execute dbms_sync_refresh.register_mviews('mv2, mv2_year, mv1_halfmonth');

--
-- Display objects in group after registering new mv's.
-- Note that all four mv's are in the same group.
-- The group_id of mv1 has changed because the
-- group has changed. Because of this, the user should not
-- rely on the actual value of the group-id but use the 
-- dbms_sync_refresh.get_group_id function to get the group_id
-- when needed.
--
select name, type, staging_log_name from user_sr_obj 
where group_id = dbms_sync_refresh.get_group_id('MV1') 
order by type, name;

---------------------------------------------------------------------------
---
--- The next session shows the use of register_partition_operation 
--- to load change data into a fact table and usage of sync-refresh
--- to refresh all objects in the group.
--- 

connect syncref_user/syncref_user


-- We will now illustrate the use of 
-- dbms_syncr_efresh.register_partition_operation() function
-- to load change data into the fact table
-- First create an outside table for the third partition of 
-- the fact table. Note it has the same constraints as the
-- fact table and is created in the correct tablespace. 

CREATE TABLE fact_ot_fp3(
	time_key		date not null references time(time_key),
	store_key		integer not null references store(store_key),
	dollar_sales		number (6,2),
	unit_sales		integer)
tablespace syncref_fp3_tbs;

--
-- Insert the data for this partition into the outside-table.
--
INSERT INTO fact_ot_fp3 VALUES('10-FEB-1998', 1, 100, 100);
INSERT INTO fact_ot_fp3 VALUES('10-FEB-1998', 2, 200, 200);
INSERT INTO fact_ot_fp3 VALUES('10-FEB-1998', 4, 400, 400);

INSERT INTO fact_ot_fp3 VALUES('11-FEB-1998', 1, 100, 100);
INSERT INTO fact_ot_fp3 VALUES('11-FEB-1998', 2, 200, 200);
INSERT INTO fact_ot_fp3 VALUES('11-FEB-1998', 4, 400, 400);

-- register this table for partition exchange. 
begin
 dbms_sync_refresh.register_partition_operation(
	          partition_op                 => 'EXCHANGE',
	          schema_name	               => 'SYNCREF_USER',
                  base_table_name	       => 'FACT',
                  partition_name	       => 'FP3',
                  outside_partn_table_schema   => 'SYNCREF_USER',
                  outside_partn_table_name     => 'FACT_OT_FP3',
                  validation                   =>  TRUE);
end;
/


col table_name format a10
col partition_name format a15
col partition_op format a10
col ot_schema  format a15
col ot_name  format a20
col staging_log_name format a15

-- 
-- Display the registered partition operation from the 
-- catalog view
-- 
select table_name, partition_op, partition_name, 
       outside_table_schema ot_schema, outside_table_name ot_name
from user_sr_partn_ops 
order by table_name;

-- Prepare the staging logs for the refresh operation. Recall we have
-- deleted all rows from the logs and they are empty. However it is
-- required that the staging logs must be prepared even though they
-- empty before a prepare_refresh.
execute dbms_sync_refresh.prepare_staging_log('syncref_user', 'fact');
execute dbms_sync_refresh.prepare_staging_log('syncref_user', 'time');
execute dbms_sync_refresh.prepare_staging_log('syncref_user', 'store');

-- Check status of staging logs after preparation;
-- the number of inserts, deletes and updates are all zero (but not non-null)
select table_name, staging_log_name, num_inserts, num_deletes, num_updates 
from user_sr_stlog_stats
order by table_name;



-- prepare_refresh - the change data comes from the registered partition
-- operation in this run.
-- Note the group consists of MV1 and the three other MV's. They will
-- all get refreshed together as a group.

execute dbms_sync_refresh.prepare_refresh( -
                    dbms_sync_refresh.get_group_id('MV1'));

--
-- display status of objects after prepare_refresh
-- 

-- Display the registered partition operation from the 
-- catalog view
select table_name, partition_op, partition_name, 
       outside_table_schema ot_schema, outside_table_name ot_name
from user_sr_partn_ops 
order by table_name;

-- Check status of staging logs after prepare_refresh;
-- the number of inserts, deletes and updates are non-null values
-- indicating that the logs have not been processed yet
select table_name, staging_log_name, num_inserts, num_deletes, num_updates 
from user_sr_stlog_stats
order by table_name;

-- Check status of objects in the group
select name, type, status from user_sr_obj_status 
where group_id = dbms_sync_refresh.get_group_id('MV1') 
order by type, name;


-- Check status of the group itself after the prepare_refresh
-- operation; note the operation field is set to PREPARE and 
-- and status is COMPLETE
select operation, status from user_sr_grp_status
where group_id = dbms_sync_refresh.get_group_id('MV1');


-- Now do the execute_refresh 
execute dbms_sync_refresh.execute_refresh( -
                    dbms_sync_refresh.get_group_id('MV1'));


-- Display the contents of the catalog view for registered
-- partition operations. The contents of this view are empty
-- indicating the registered partition operation has been 
-- processed by execute_refresh.
select table_name, partition_op, partition_name, 
       outside_table_schema ot_schema, outside_table_name ot_name
from user_sr_partn_ops 
order by table_name;

-- Check status of staging logs after execute_refresh;
-- the contents of this view are also empty indicating that
-- the logs have been processed 
select table_name, staging_log_name, num_inserts, num_deletes, num_updates 
from user_sr_stlog_stats
order by table_name;

-- Check status of objects in the group; since STORE and TIME 
-- are unchanged, their status is NOT PROCESSED.
select name, type, status from user_sr_obj_status 
where group_id = dbms_sync_refresh.get_group_id('MV1') 
order by type, name;

-- Check status of the group itself after the execute_refresh
-- operation; note the operation field is set to EXECUTE and 
-- and status is COMPLETE
select operation, status from user_sr_grp_status
where group_id = dbms_sync_refresh.get_group_id('MV1');

------------------------------------------------------------------
---
--- The following session shows the use of the DO_CST and DO_CST_ARR wrappers
--- to display information from the can_syncref_table procedure. In addition
--- to the four mvs already created, we create some more mvs which are
--- ineligible for sync-refresh. The messages which make the mvs ineligible 
--- for sync-refresh have the string 'ERROR!' appended to them.
--- 

connect syncref_user/syncref_user

-- Create mvs which are ineligible for sync-refresh for one reason or another
-- The analysis by can_syncref_table will explain the reason for their 
-- ineligibilty.  
CREATE MATERIALIZED VIEW mv1_cs1a
  PARTITION BY RANGE (time_key)
  (
    partition month1_mv
      values less than (TO_DATE('31-12-1997', 'DD-MM-YYYY'))
      tablespace syncref_mvp1_tbs,

    partition month2_mv
      values less than (TO_DATE('31-01-1998', 'DD-MM-YYYY'))
      tablespace syncref_mvp2_tbs,

    partition month3_mv
      values less than (TO_DATE('28-02-1999', 'DD-MM-YYYY'))
      tablespace syncref_mvp3_tbs
 )
REFRESH USING TRUSTED CONSTRAINTS
 AS
 SELECT f.store_key, s.store_name, t.year, f.time_key,
        SUM(f.dollar_sales) as dollar_sales, 
        COUNT(f.dollar_sales) as cnt_dsales,
        COUNT(*) as cnt
 FROM fact f, store s, time t
 WHERE s.store_key = f.store_key  
 GROUP BY t.year, f.store_key, s.store_name, f.time_key;

CREATE MATERIALIZED VIEW mv1_cs1c
  PARTITION BY RANGE (store_key)
  (
    partition st1
      values less than (10)
      tablespace syncref_mvp1_tbs,

    partition st2
      values less than (20)
      tablespace syncref_mvp2_tbs,

    partition st3_default
      values less than (MAXVALUE)
      tablespace syncref_mvp3_tbs
 )
REFRESH USING TRUSTED CONSTRAINTS
 AS
 SELECT f.store_key, s.store_name, t.year, f.time_key,
        SUM(f.dollar_sales) as dollar_sales, 
        COUNT(f.dollar_sales) as cnt_dsales,
        COUNT(*) as cnt
 FROM fact f, store s, time t
 WHERE s.store_key = f.store_key  AND
       f.time_key = t.time_key
 GROUP BY t.year, f.store_key, s.store_name, f.time_key;

CREATE MATERIALIZED VIEW mv1_cs1d
  PARTITION BY RANGE (store_key)
  (
    partition st1
      values less than (10)
      tablespace syncref_mvp1_tbs,

    partition st2
      values less than (20)
      tablespace syncref_mvp2_tbs,

    partition st3_default
      values less than (MAXVALUE)
      tablespace syncref_mvp3_tbs
 )
REFRESH USING TRUSTED CONSTRAINTS
 AS
 SELECT s.store_key, s.store_name, t.year, f.time_key,
        SUM(f.dollar_sales) as dollar_sales, 
        COUNT(f.dollar_sales) as cnt_dsales,
        COUNT(*) as cnt
 FROM fact f, store s, time t
 WHERE s.store_key = f.store_key  AND
       f.time_key = t.time_key
 GROUP BY t.year, s.store_key, s.store_name, f.time_key;

CREATE MATERIALIZED VIEW mv1_cs1e
  PARTITION BY RANGE (store_name)
  (
    partition st1
      values less than ('A')
      tablespace syncref_mvp1_tbs,

    partition st2
      values less than ('M')
      tablespace syncref_mvp2_tbs,

    partition st3_default
      values less than (MAXVALUE)
      tablespace syncref_mvp3_tbs
 )
REFRESH USING TRUSTED CONSTRAINTS
 AS
 SELECT s.store_key, s.store_name, t.year, f.time_key,
        SUM(f.dollar_sales) as dollar_sales, 
        COUNT(f.dollar_sales) as cnt_dsales,
        COUNT(*) as cnt
 FROM fact f, store s, time t
 WHERE s.store_key = f.store_key  AND
       f.time_key = t.time_key
 GROUP BY t.year, s.store_key, s.store_name, f.time_key;

CREATE MATERIALIZED VIEW mv1_cs1f
  PARTITION BY RANGE (cnt)
  (
    partition st1
      values less than (1)
      tablespace syncref_mvp1_tbs,

    partition st2
      values less than (10)
      tablespace syncref_mvp2_tbs,

    partition st3_default
      values less than (MAXVALUE)
      tablespace syncref_mvp3_tbs
 )
REFRESH USING TRUSTED CONSTRAINTS
 AS
 SELECT s.store_key, s.store_name, t.year, f.time_key,
        SUM(f.dollar_sales) as dollar_sales, 
        COUNT(f.dollar_sales) as cnt_dsales,
        COUNT(*) as cnt
 FROM fact f, store s, time t
 WHERE s.store_key = f.store_key  AND
       f.time_key = t.time_key
 GROUP BY t.year, s.store_key, s.store_name, f.time_key;

CREATE MATERIALIZED VIEW mv2_cs2a
  PARTITION BY RANGE (month)
  (
    partition year1_mv
      values less than (199712)
      tablespace syncref_mvp1_tbs,

    partition year2_mv
      values less than (199812)
      tablespace syncref_mvp2_tbs
 )
REFRESH USING TRUSTED CONSTRAINTS
 AS
 SELECT  s.zipcode, t.month, 
        SUM(f.dollar_sales) as dollar_sales, 
        COUNT(f.dollar_sales) as cnt_dsales,
        COUNT(*) as cnt
 FROM fact f, store s, time t
 WHERE s.store_key = f.store_key  AND
       f.time_key = t.time_key
 GROUP BY s.zipcode, t.month;


-- Create SYNCREF_TABLE 
@utlsrt

set echo on
-- Load the DO_CST and DO_CST_ARR wrapper procedures
@syncref_cst

set echo on
set feedback on
set serveroutput on

-- Use the table interface to can_syncref_table
execute do_cst('SYNCREF_USER', 'FACT', 'S001');

-- Use the array interface to can_syncref_table
-- Note: this produces the same output as the previous method.
execute do_cst_arr('SYNCREF_USER', 'FACT');

-----------------------------------------------------------------------------------
--
-- Run syncref_cleanup.sql to drop the user and tablespaces referenced in this script.
--
@syncref_cleanup.sql
